/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.data.impl.util;

import io.gitlab.jfronny.commons.data.impl.node.Node;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class NodeUtil {
    public static <T> int binarySearchForEdge(AtomicReferenceArray<Node<T>> childNodes, Character edgeFirstCharacter) {
        int low = 0;
        int high = childNodes.length() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Node<T> midVal = childNodes.get(mid);
            int cmp = midVal.getIncomingEdgeFirstCharacter().compareTo(edgeFirstCharacter);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static <T> void precheckCreation(CharSequence edgeCharacters, List<Node<T>> children, boolean isRoot) {
        if (edgeCharacters == null) {
            throw new IllegalStateException("The edgeCharacters argument was null");
        }
        if (!isRoot && edgeCharacters.length() == 0) {
            throw new IllegalStateException("Invalid edge characters for non-root node: " + String.valueOf(edgeCharacters));
        }
        if (children == null) {
            throw new IllegalStateException("The childNodes argument was null");
        }
        HashSet<Character> uniqueChars = new HashSet<Character>(children.size());
        for (Node<T> node : children) {
            uniqueChars.add(node.getIncomingEdgeFirstCharacter());
        }
        if (children.size() != uniqueChars.size()) {
            throw new IllegalStateException("Duplicate edge detected in list of nodes supplied: " + String.valueOf(children));
        }
    }
}

